;;;  Dateiname: spartreppe.lsp  -  erstellt: Thomas Elbracht
;;;  1.2023  -  fr AC2022               mail: te@elbracht-web.de
;;;  Aufruf mit: spartreppe
;;;
;;;  Die Routine erstellt eine Spartreppe fr den Einrichtungsplaner
;;
  (defun Te:S-treppeIni ()
  ; speichert die Variablen
  (if *error*				
    (setq *te:error* *error*)		
  )

  (setq cealt (getvar "CMDECHO")
        mealt (getvar "MENUECHO")
	osalt (getvar "OSMODE")
	ortalt (getvar "ORTHOMODE")
	layalt (getvar "CLAYER")
	coalt (getvar "CECOLOR")
	delalt (getvar "DELOBJ")
	)
  
  	(setvar "CMDECHO" 0)
	(setvar "MENUECHO" 0)
  	(setvar "OSMODE" 0)
        (setvar "ORTHOMODE" 0)
        (setvar "DELOBJ" 2)
    
  (defun *error* (sTxt)	
    (princ (strcat "\n" sTxt))

  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
  (setvar "OSMODE" osalt)
  (setvar "ORTHOMODE" ortalt)
  (setvar "CECOLOR" coalt)
  (setvar "DELOBJ" delalt)
    
    (if	*te:error*
      (setq *error* *te:error*)	
      (setq *error* nil)
    )
    (princ)
  )
nil
)
(defun Te:S-treppeDlg ()

(setq next 4)
(setq	IMG1 "spartreppe(logo)"
	fil1 IMG1
  ) 
(if (not dcl_id) (setq dcl_id (load_dialog "spartreppe")))

  (while (> next 1)
  (new_dialog "S_treppe" dcl_id)

	(setq brei (dimx_tile "DIA"))
    	(setq hoe (dimy_tile "DIA"))
    	(start_image "DIA")
    	(fill_image 0 0 brei hoe -2)
    	(slide_image -30 -100 600 500 "spartreppe(spartreppe)")
	(end_image)
 
    (start_image "IMG1") 
    (slide_image 180 -40 180 130 fil1)
    (end_image)
    (set_tile "DGH" (rtos GH 2 0))
    (set_tile "DLlL" (rtos LlL 2 0))
    (set_tile "DTB" (rtos TB 2 0))
    (set_tile "DWD" (rtos WD 2 0))
    (set_tile "DSD" (rtos SD 2 0))
    (set_tile "DStufRa" (rtos StufRa 2 0))
    (set_tile "DATB" (rtos ATB 2 0))
    (set_tile "DSTH" (rtos STH 2 2))
    (set_tile "DSTZ" (rtos STZ 2 0))
    (set_tile "DSCM" (rtos SCM 2 0))
        
    (action_tile "DGH" "(DO_GH)")
    (action_tile "DLlL" "(setq LlL (atof $value))")
    (action_tile "DTB" "(setq TB (atof $value))")
    (action_tile "DWD" "(setq WD (atof $value))")
    (action_tile "DSD" "(setq SD (atof $value))")
    (action_tile "DStufRa" "(setq StufRa (atof $value))")
    (action_tile "DSTZ" "(DO_StufZ)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "cancel" "(done_dialog 0)")
   (setq next (start_dialog))
    
(if (= next 1) 
  (Te:S-treppeZeich)
  (Te:S-treppeBack)
  )
    )
  (unload_dialog dcl_id)
)
(defun Te:S-treppeZeich ()
  (vl-load-com)
  (if(/=(getvar "WORLDUCS")1)
    (equal (distance '(0 0 1.0) (cons 0(cons 0(cdr(cdr(trans '(0 0 1)1 0))))))0.0 0.00000001)
    'T)
  (vl-cmdf "_.view" "S" "TE_VIEW")
  (vl-cmdf "_.UCS" "")
  (vl-cmdf "_.PLAN" "W")
  (setvar "CMDECHO" 0)
  (command-s "LAYER" "_M" "Te_S-Treppe" "_CO" "32" "Te_S-Treppe" "")

  (setvar "osmode" 0)(setvar "DELOBJ" 2)
  (setq EP (getpoint "\n Einfgepunkt angeben, vorne links  "))
  (setq Wi (aib 180) Wio (aib 90.0) Wiu (aib 270.0) Wir 0.0)
  (if (/=(type STZ) REAL) (setq STZ (fix STZ)))
  
(setq StufL (- TB (* WD 2.0))
      StufEP (list (car EP)(+(cadr EP)70.0)(caddr EP))
      StufRa2 (* StufRa 2.0)
      Stuf1 (polar StufEP Wiu (- 70.0 StufRa))
      Stuf2 (list (+(car Stuf1)StufRa)(-(cadr Stuf1)StufRa)(caddr StufEP))
      Stuf3 (polar Stuf2 Wir (-(/ TB 2.0) StufRa StufRa2))
      Stuf4 (list (+(car Stuf3)StufRa)(+(cadr Stuf3)StufRa)(caddr StufEP))
      Stuf5 (polar Stuf4 Wio (- ATB ATBk StufRa2))
      Stuf6 (list (+(car Stuf5)StufRa)(+(cadr Stuf5)StufRa)(caddr StufEP))
      Stuf7 (polar Stuf6 Wir (-(/ TB 2.0) WD))
      Stuf8 (polar Stuf7 Wio 20.0)
      Stuf9 (polar Stuf8 Wir WD)
      Stuf10 (polar Stuf9 Wio 50.0)
      Stuf11 (polar Stuf10 Wi WD)
      Stuf12 (polar Stuf11 Wio 30.0)
      Stuf13 (polar Stuf12 Wi (- TB (* WD 2.0)))
      Stuf14 (polar Stuf13 Wiu 30.0)
      Stuf15 (polar Stuf14 Wi WD)
      Stuf16 (polar Stuf15 Wiu 50.0)
      Stuf17 (polar Stuf16 Wir WD)
      Stuf18 (list (car Stuf17)(cadr StufEP)(caddr StufEP))
      Stuf19 (polar Stuf1 Wir (/ TB 2.0))
      Stuf20 (polar Stuf19 Wio 300.0)
      endLlL (list (car EP)(+(cadr EP)LlL)(caddr EP))
      endGH (list (car EP)(+(cadr EP)LlL)(+ (caddr EP)GH))
      endGH2 (list (car EP)(-(cadr endGH) ATB)(-(caddr endGH)(+ STH SD)))
      endGH3 (list (car EP)(-(cadr endGH) ATB)(caddr endGH))      
      WanHko (list (car EP)(cadr endGH)(caddr endGH2))
      StufVku1 (list (car EP)(+(cadr EP)15.0)(+(caddr EP)(- STH SD)))
      StufVku2a (list (car EP)(cadr StufVku1)(+(caddr StufVku1)STH))
      WanVk (list (car StufVku1)(+(cadr StufVku1) 15.0)(caddr StufVku1))
      WanHku (list (car StufVku1)(+(cadr WanVk)ATB)(caddr StufVku1))
      )

(vl-cmdf "_pline" StufEP Stuf1 "k" Stuf2 "li" Stuf3 "k" Stuf4 "li" Stuf5 "k" Stuf6 "li" Stuf7 Stuf8
	 Stuf9 Stuf10 Stuf11 Stuf12 Stuf13 Stuf14 Stuf15 Stuf16 Stuf17 Stuf18 "s")
  (setq Mstuf1 (entlast))
  (vl-cmdf "_mirror"  Mstuf1 "" Stuf19 Stuf20 "")
  (setq Mstuf2 (entlast))
  (vl-cmdf "_extrude" Mstuf1 "" SD)
  (setq Mstuf1 (entlast))
  (vl-cmdf "_move" Mstuf1 "" EP StufVku1 "" "")
  (vl-cmdf "_extrude" Mstuf2 "" SD)
  (setq Mstuf2 (entlast))
  (vl-cmdf "_.UCS" "_z" "")
  (vl-cmdf "_.UCS" "_x" "")
  (vl-cmdf "_.PLAN" "")
  (vl-cmdf "_.view" "S" "TE_VIEW2")

  (setq nEP (trans EP 0 1) nendGH (trans endGH 0 1)
	nWanVk (trans WanVk 0 1) nendGH2 (trans endGH2 0 1)
	nStufVku1 (trans StufVku1 0 1) nStufVku2a (trans StufVku2a 0 1)
	nStufVku2b (polar nStufVku2a Wir 200.0)
	nWanHku (trans WanHku 0 1)
	nWanHko (trans WanHko 0 1)
	nendGH3 (trans endGH3 0 1))
    (setq win(angle nWanVk nendGH2) rwin(bia win))
    (setq nAbst3 (float(distance nWanVk nendGH2)))
    (setq nAbst4 (float(/ nAbst3 STZ)))
  (setq nStufVku2c (polar nStufVku1 win 600))
  (setq op (inters nStufVku1 nStufVku2c nStufVku2a nStufVku2b))
  
    (vl-cmdf "_move" Mstuf2 "" nEP op "" "")
    (setq nAbst (distance nStufVku1 op) nAbst2 (* nAbst 2)
	  STZ2 (/ STZ 2))

    (setq nEPh (list (car nEP)(+(cadr nEP)300)(caddr nEP))
	nEPr (list (+(car nEP)400)(cadr nEP)(caddr nEP)))

    (setq op2(inters nEP nEPh nWanVk nendGH2 nil))
    (setq nWanVk33 (polar op2 win 3100))
(setq WP1(inters nEP nEPr nWanHku nWanHko nil)
      WP2(inters nendGH nendGH3 op2 nWanVk33 nil)
    )
    
      (setq NWP (polar nWanVk (+ win 1.5708)1000))
 (vl-cmdf "_.UCS" "3P" nWanVk nendGH2 NWP)
 (vl-cmdf "_.PLAN" "")
 (vl-cmdf "_.array" Mstuf2 "" "" "" STZ2 nAbst2)

  (setq a (- STZ (* STZ2 2)))
  (if (= a 1)
    (vl-cmdf "_.array" Mstuf1 "" "" "" (+ STZ2 1) nAbst2)
    (vl-cmdf "_.array" Mstuf1 "" "" "" STZ2 nAbst2)
    )

(vl-cmdf "_.view" "H" "TE_VIEW2")
 
    (vl-cmdf "CECOLOR" 22)	
    (vl-cmdf "_pline" nEP WP1 nWanHko nendGH WP2 op2 "s")
    (setq 1Wan (entlast))
  (vl-cmdf "_extrude" 1Wan "" WD)(setq 1Wan (entlast))
  (vl-cmdf "_.view" "H" "TE_VIEW")
  (vl-cmdf "_.UCS" "")
  
  (vl-cmdf "_mirror"  1Wan "" Stuf19 Stuf20 "")
  (vl-cmdf "_.view" "L" "TE_VIEW")
  (vl-cmdf "_.view" "L" "TE_VIEW2")
)

(DEFUN aib (w) (* pi (/ w 180.0)))(DEFUN bia (Wi) (* 180 (/ Wi Pi)))
(defun DO_GH ()	
 (setq GH (atof $value))
 (setq STH (float (/ GH STZcal)))
  (DO_SCM)
  (set_tile "DSTH" (rtos STH))
)
(defun DO_StufH ()	
 (setq STH (atof $value))
  (setq STZ (fix(float (/ GH STH))))
  (setq STZcal (float(/ GH (+ STZ 1.0))))

  (DO_SCM)
 (set_tile "DSTH" (rtos STH 2 2))
  (set_tile "DSTZ" (rtos STZ))
)
(defun DO_StufZ ()	
 (setq STZ (atof $value))
 (setq STZcal (+ STZ 1.0))
 (setq STH (float(/ GH STZcal)))
 
  (set_tile "DSTH" (rtos STH))
  (DO_SCM)
)
(defun DO_SCM ()
(setq SCM (+(* STH 2) ATB))
      (set_tile "DSCM" (rtos SCM))
)  
(defun Te:S-treppeBack ()
  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
  (setvar "OSMODE"  osalt)
  (setvar "ORTHOMODE" ortalt)
  (setvar "CLAYER"  layalt)
  (setvar "CECOLOR" coalt)
  (setvar "DELOBJ" delalt)
)
(defun C:spartreppe ( / dcl_id cealt mealt osalt ortalt layalt coalt delalt GH LlL TB WD SD StufRa ATB ATBk
		    STH STZ STZcal SCM next IMG1 fil1 brei hoe EP Wi Wio Wiu Wir StufL StufEP StufRa2 Stuf1
		    Stuf2 Stuf3 Stuf4 Stuf5 Stuf6 Stuf7 Stuf8 Stuf9 Stuf10 Stuf11 Stuf12 Stuf13 Stuf14 Stuf15
		    Stuf16 Stuf17 Stuf17 Stuf18 Stuf19 Stuf20 endLlL endGH endGH2 endGH3 WanHko StufVku1
		    StufVku2a WanVk WanHku Mstuf1 Mstuf2 nEP nWanVk nStufVku1 nStufVku2b nWanHku nWanHko
		    nendGH3 win rwin nAbst3 nAbst4 nStufVku2c op nAbst nAbst2 STZ2 NWP a nEPh nEPr op2 nWanVk33
		    WP1 WP2 1Wan)

  (Te:S-treppeIni) 
  
(setq GH  2750    ; Geschohhe
      LlL 1500    ; Treppenffnung oder Lauflinienlnge   286.6667 183.3333
      TB 800      ; Treppenbreite
      WD 50       ; Wangendicke
      WB 200      ; Wangenbreite
      SD 45       ; Stufendicke
      StufRa 20   ; Stufenradius
      ATB 250     ; Auftritt
      ATBk 100.0  ; Auftritt klein
      STH 196.429 ; Steigung
      STZ 13      ; Stufenzahl
      STZcal 14.0 ; Stufenzahl Calkulier
      SCM (+(* STH 2) ATB)     ; Schrittma
)

	(Te:S-treppeDlg)
	(Te:S-treppeBack)
  	(princ)
  
  )
  (princ "\n  Copyright (c) 2023 Thomas Elbracht ")
  (princ "\n  Starten Sie mit dem Befehl << spartreppe >>  ")
  (princ)(princ)

